***********************************************
***********************************************
**		Replication .do file for			 **
**		Bowersox (2016)						 **
**		Naming, Shaming, and Int. Sports	 **
***********************************************
***********************************************


* using Bowersox_PRQ_Replication_Data.dta *


**
****
****** MODELS
****
**

*Table One (w/ yearly-fixed effects reported in Table 6)

reg physint Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year physint_tm1

reg physint Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year physint_tm1


*Table Two (w/ yearly-fixed effects reported in Table 7)

reg empower Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year empower_tm1

reg empower Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year empower_tm1



*Table Three (w/ yearly-fixed effects reported in Table 8)

reg expressive Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year express_tm1

reg expressive Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year express_tm1


*Table Nine

	*Kill
	reg kill Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year kill_tm1
		
	reg kill Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year kill_tm1
		
	*polpris
	reg polpris Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year polpris_tm1
		
	reg polpris Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year polpris_tm1
		
	*torture
	reg torture Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year tort_tm1
		
	reg torture Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year tort_tm1
		
	*Disappear
	reg disap Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year disap_tm1
		
	reg disap Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year disap_tm1
		



*Table 10

	*Speech
	reg speech Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year speech_tm1

	reg speech Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year speech_tm1

	*Association
	reg association Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year assoc_tm1

	reg association Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year assoc_tm1

	*Political Participation
	reg polpar Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year polpar_tm1

	reg polpar Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year polpar_tm1

	*Religion
	reg religion Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year relig_tm1
	
	reg religion Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year relig_tm1
		

*Table 11

reg latentmean Iolymp_prox olympics_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos latent_tm1

reg latentmean Icup_prox cup_prox ai_reports lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos latent_tm1



*
***
***** GRAPHS
***
*

********************** FIGURE 1.A ***********************************************************

reg physint olympics_prox ai_reports Iolymp_prox lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year physint_tm1

matrix b=e(b)
matrix V=e(V)

matrix list b
matrix list V

local k = colsof(b)
foreach c of numlist 1(1)`k' {
	local b`c' = b[1,`c']
	local varb`c' = V[`c',`c']
	foreach r of numlist 1(1)`k' {
		local covb`r'b`c' = V[`r',`c']
	}
}

postfile int Z ME_X SE_X LO_X HI_X X ME_Z SE_Z LO_Z HI_Z using "Marginal Effects.dta", replace

foreach i of numlist 0(20)80 {
	local ME_X = `b1' + (`b3' * `i')
	local SE_X = sqrt(`varb1'+((`i'^2)*`varb3')+(2*`i'*`covb1b3'))
	local LO_X = `ME_X' - (1.96 * `SE_X')
	local HI_X = `ME_X' + (1.96 * `SE_X')
	
	post int (`i') (`ME_X') (`SE_X') (`LO_X') (`HI_X') (.) (.) (.) (.) (.) 

}

foreach i of numlist 8(1)40 {
	local ME_Z = `b2' + (`b3' * `i')
	local SE_Z = sqrt(`varb2'+((`i'^2)*`varb3')+(2*`i'*`covb2b3'))
	local LO_Z = `ME_Z' - (1.96 * `SE_Z')
	local HI_Z = `ME_Z' + (1.96 * `SE_Z')
	
	post int (.) (.) (.) (.) (.) (`i') (`ME_Z') (`SE_Z') (`LO_Z') (`HI_Z') 

}

postclose int

use "Marginal Effects.dta", clear

twoway (line ME_X Z) (line LO_X Z, lpattern(dash)) (line HI_X Z, lpattern(dash)), /*
*/	xtitle("AI Reports") ytitle("Physical Integrity Rights") note("Dashed lines represent 95% confidence intervals") yline(0) legend(off) scheme(s1mono)

*********************************************************END*****************************************



********************** FIGURE 1.B ***********************************************************

reg physint cup_prox ai_reports Icup_prox lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year physint_tm1

matrix b=e(b)
matrix V=e(V)

matrix list b
matrix list V

local k = colsof(b)
foreach c of numlist 1(1)`k' {
	local b`c' = b[1,`c']
	local varb`c' = V[`c',`c']
	foreach r of numlist 1(1)`k' {
		local covb`r'b`c' = V[`r',`c']
	}
}

postfile int Z ME_X SE_X LO_X HI_X X ME_Z SE_Z LO_Z HI_Z using "Marginal Effects.dta", replace

foreach i of numlist 0(20)80 {
	local ME_X = `b1' + (`b3' * `i')
	local SE_X = sqrt(`varb1'+((`i'^2)*`varb3')+(2*`i'*`covb1b3'))
	local LO_X = `ME_X' - (1.96 * `SE_X')
	local HI_X = `ME_X' + (1.96 * `SE_X')
	
	post int (`i') (`ME_X') (`SE_X') (`LO_X') (`HI_X') (.) (.) (.) (.) (.) 

}

foreach i of numlist 8(1)40 {
	local ME_Z = `b2' + (`b3' * `i')
	local SE_Z = sqrt(`varb2'+((`i'^2)*`varb3')+(2*`i'*`covb2b3'))
	local LO_Z = `ME_Z' - (1.96 * `SE_Z')
	local HI_Z = `ME_Z' + (1.96 * `SE_Z')
	
	post int (.) (.) (.) (.) (.) (`i') (`ME_Z') (`SE_Z') (`LO_Z') (`HI_Z') 

}

postclose int

use "Marginal Effects.dta", clear

twoway (line ME_X Z) (line LO_X Z, lpattern(dash)) (line HI_X Z, lpattern(dash)), /*
*/	xtitle("AI Reports") ytitle("Physical Integrity Rights") note("Dashed lines represent 95% confidence intervals") yline(0) legend(off) scheme(s1mono)

*********************************************************END*****************************************



********************** FIGURE 2.A ***********************************************************

reg expressive olympics_prox ai_reports Iolymp_prox lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year express_tm1

matrix b=e(b)
matrix V=e(V)

matrix list b
matrix list V

local k = colsof(b)
foreach c of numlist 1(1)`k' {
	local b`c' = b[1,`c']
	local varb`c' = V[`c',`c']
	foreach r of numlist 1(1)`k' {
		local covb`r'b`c' = V[`r',`c']
	}
}

postfile int Z ME_X SE_X LO_X HI_X X ME_Z SE_Z LO_Z HI_Z using "Marginal Effects.dta", replace

foreach i of numlist 0(20)80 {
	local ME_X = `b1' + (`b3' * `i')
	local SE_X = sqrt(`varb1'+((`i'^2)*`varb3')+(2*`i'*`covb1b3'))
	local LO_X = `ME_X' - (1.96 * `SE_X')
	local HI_X = `ME_X' + (1.96 * `SE_X')
	
	post int (`i') (`ME_X') (`SE_X') (`LO_X') (`HI_X') (.) (.) (.) (.) (.) 

}

foreach i of numlist 8(1)40 {
	local ME_Z = `b2' + (`b3' * `i')
	local SE_Z = sqrt(`varb2'+((`i'^2)*`varb3')+(2*`i'*`covb2b3'))
	local LO_Z = `ME_Z' - (1.96 * `SE_Z')
	local HI_Z = `ME_Z' + (1.96 * `SE_Z')
	
	post int (.) (.) (.) (.) (.) (`i') (`ME_Z') (`SE_Z') (`LO_Z') (`HI_Z') 

}

postclose int

use "Marginal Effects.dta", clear

twoway (line ME_X Z) (line LO_X Z, lpattern(dash)) (line HI_X Z, lpattern(dash)), /*
*/	xtitle("AI Reports") ytitle("Expressive Rights") note("Dashed lines represent 95% confidence intervals") yline(0) legend(off) scheme(s1mono)

*********************************************************END*****************************************



********************** FIGURE 2.B ***********************************************************

reg expressive cup_prox ai_reports Icup_prox lgdppc lpop polity2 ltrade injud exconst icrg_qog hrigos i.year express_tm1

matrix b=e(b)
matrix V=e(V)

matrix list b
matrix list V

local k = colsof(b)
foreach c of numlist 1(1)`k' {
	local b`c' = b[1,`c']
	local varb`c' = V[`c',`c']
	foreach r of numlist 1(1)`k' {
		local covb`r'b`c' = V[`r',`c']
	}
}

postfile int Z ME_X SE_X LO_X HI_X X ME_Z SE_Z LO_Z HI_Z using "Marginal Effects.dta", replace

foreach i of numlist 0(20)80 {
	local ME_X = `b1' + (`b3' * `i')
	local SE_X = sqrt(`varb1'+((`i'^2)*`varb3')+(2*`i'*`covb1b3'))
	local LO_X = `ME_X' - (1.96 * `SE_X')
	local HI_X = `ME_X' + (1.96 * `SE_X')
	
	post int (`i') (`ME_X') (`SE_X') (`LO_X') (`HI_X') (.) (.) (.) (.) (.) 

}

foreach i of numlist 8(1)40 {
	local ME_Z = `b2' + (`b3' * `i')
	local SE_Z = sqrt(`varb2'+((`i'^2)*`varb3')+(2*`i'*`covb2b3'))
	local LO_Z = `ME_Z' - (1.96 * `SE_Z')
	local HI_Z = `ME_Z' + (1.96 * `SE_Z')
	
	post int (.) (.) (.) (.) (.) (`i') (`ME_Z') (`SE_Z') (`LO_Z') (`HI_Z') 

}

postclose int

use "Marginal Effects.dta", clear

twoway (line ME_X Z) (line LO_X Z, lpattern(dash)) (line HI_X Z, lpattern(dash)), /*
*/	xtitle("AI Reports") ytitle("Expressive Rights") note("Dashed lines represent 95% confidence intervals") yline(0) legend(off) scheme(s1mono)

*********************************************************END*****************************************


************************************Figure 3.A******************************************************

reg protest olymp_select##c.ai_reports gdplog poplog injud exconst icrg_qog hrigos i.year protest_tm1
twoway (scatter protest Media_ai_tot, msym(oh) jitter(3)) ///
       (lfit protest Media_ai_tot if ~olymp_select)(lfit protest Media_ai_tot if olymp_select), ///
	   legend(order(2 "No Select" 3 "Select"))

margins, dydx(olymp_select) at(Media_ai_tot=(0(5)20)) vsquish 
marginsplot, recast(line) recastci(rarea) yline(0)

**********************************Figure 3.B***********************************************************

reg protest soccer_select##c.ai_reports gdplog poplog injud exconst icrg_qog hrigos i.year protest_tm1
twoway (scatter protest Media_ai_tot, msym(oh) jitter(3)) ///
       (lfit protest Media_ai_tot if ~soccer_select)(lfit protest Media_ai_tot if soccer_select), ///
	   legend(order(2 "No Select" 3 "Select"))
	   